/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.2,0.277777)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

float hash ( float n )
{
    n = mod ( n, 64.0 );
    return fract ( sin(n)*43758.5453 );
}

float noise ( vec2 p )
{
    return hash ( p.x + p.y*57.0 );
}

float smoothNoise2 ( vec2 p )
{
    vec2 p0 = floor ( p + vec2(0.0,0.0) );
    vec2 p1 = floor ( p + vec2(1.0,0.0) );
    vec2 p2 = floor ( p + vec2(0.0,1.0) );
    vec2 p3 = floor ( p + vec2(1.0,1.0) );

    vec2 pf = fract ( p );

    return mix ( mix ( noise(p0), noise(p1), pf.x ), 
                 mix ( noise(p2), noise(p3), pf.x ), pf.y );
}

vec2 cellPoint ( vec2 cell )
 {
   return vec2 ( noise(cell)     + cos(cell.y)*0.3,
                 noise(cell*0.3) + sin(cell.x)*0.3
               );
 }

vec3 voronoi2 ( vec2 t, float pw )
 {
    vec2 p = floor(t);

    float wsum = 0.0;
    vec3  vsum = vec3(0.0);

    for ( int y = -1; y < 2; y++ )
     {
       for ( int x = -1; x < 2; x++ )
        {
          vec2 q = p + vec2 ( float(x), float(y) );
          vec2 r = mod ( q, 8.0 );
          vec2 c = q + cellPoint(r);
          vec2 s = 1.0 - abs(c-t);

          float a1 = smoothstep ( 0.0, 1.0, s.x );
          float a2 = smoothstep ( 0.0, 1.0, s.y );

          float w = pow(a1,pw) * pow(a2,pw);

          float f = cos ( ( r.x + r.y*119.0 ) * 8.0 );

          vsum += vec3 ( (1.0+f)*0.5*w );
          wsum += w;

        }

      }

    return sqrt ( vsum/wsum ) * 2.0;
 }

vec3 voronoi ( vec2 t )
 {
   vec3 v1 = voronoi2 ( t*0.25, 16.0 );
   vec3 v2 = voronoi2 ( t*0.50 + v1.xy, 2.0);
   vec3 v3 = voronoi2 ( t*0.50, 4.0 ) * 0.5;

   return v1*v2 + v3;

 }

void main ( void )
 {
   vec2 tt = ( gl_FragCoord.xy + iMouse.xy ) / iResolution.y;
   tt = fract ( (tt+1.0)*0.5 ) * 100.0;

   float x0 = voronoi(tt).r;
   float x1 = voronoi(tt+vec2(0.01,0.00)).r;
   float x2 = voronoi(tt+vec2(0.00,0.01)).r;

   vec3 xx = vec3 ( (x1-x0)*100.0, (x2-x0)*100.0, 8.0 );

   vec3 c1 = vec3(0.04,0.04,0.08);
   vec3 c2 = vec3(1.05,1.05,1.00);

   vec3 n1 = normalize ( vec3(1.0,10.0,5.0) );
   vec3 n2 = normalize ( xx + 1.0 );

   gl_FragColor.rgb = 0.86 * mix ( c1, c2, (1.0+dot(n1,n2))*0.5 );
   gl_FragColor.a   = 1.0;

 }

